<?php

/**

 * @package     Joomla.Site

 * @subpackage  Templates.protostar

 *

 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.

 * @license     GNU General Public License version 2 or later; see LICENSE.txt

 */

defined('_JEXEC') or die;

$app             = JFactory::getApplication();

$doc             = JFactory::getDocument();

$user            = JFactory::getUser();

$this->language  = $doc->language;

$this->direction = $doc->direction;

// Getting params from template

$params = $app->getTemplate(true)->params;

// Detecting Active Variables

$option   = $app->input->getCmd('option', '');

$view     = $app->input->getCmd('view', '');

$layout   = $app->input->getCmd('layout', '');

$task     = $app->input->getCmd('task', '');

$itemid   = $app->input->getCmd('Itemid', '');

$sitename = $app->get('sitename');

if($task == "edit" || $layout == "form" )

{

	$fullWidth = 1;

}

else

{

	$fullWidth = 0;

}

// Add JavaScript Frameworks

JHtml::_('bootstrap.framework');

$doc->addScript($this->baseurl . '/templates/' . $this->template . '/js/animation_header.js');

$doc->addScript($this->baseurl . '/templates/' . $this->template . '/js/bootstrap.js');

$doc->addScript($this->baseurl . '/templates/' . $this->template . '/js/bootstrap.min.js');

// Add Stylesheets

$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/bootstrap.css');

$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/bootstrap.min.css');

$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/style.css');

$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/font-awesome-4.2.0/css/font-awesome.min.css');

// Load optional RTL Bootstrap CSS

JHtml::_('bootstrap.loadCss', false, $this->direction);

// Adjusting content width

if ($this->countModules('position-7') && $this->countModules('position-8'))

{

	$span = "span6";

}

elseif ($this->countModules('position-7') && !$this->countModules('position-8'))

{

	$span = "span9";

}

elseif (!$this->countModules('position-7') && $this->countModules('position-8'))

{

	$span = "span9";

}

else

{

	$span = "span12";

}

// Logo file or site title param

if ($this->params->get('logoFile'))

{

	$logo = '<img src="' . JUri::root() . $this->params->get('logoFile') . '" alt="' . $sitename . '" />';

}

elseif ($this->params->get('sitetitle'))

{

	$logo = '<span class="site-title" title="' . $sitename . '">' . htmlspecialchars($this->params->get('sitetitle')) . '</span>';

}

else

{

	$logo = '<span class="site-title" title="' . $sitename . '">' . $sitename . '</span>';

}



?>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">

<head>

<meta name="viewport" content="width=device-width, initial-scale=1.0" />

<jdoc:include type="head" />

<?php // Template color ?>

<?php if ($this->params->get('templateColor')) : ?>

<?php endif; ?>

<!--[if lt IE 9]>



		<script src="<?php echo JUri::root(true); ?>/media/jui/js/html5.js"></script>



	<![endif]-->

<?php 

$active = JFactory::getApplication()->getMenu()->getActive();

?>

</head>

<!-- oncontextmenu="return false" onmousedown="return false" -->

<body data-target="navbar-fixed-top" class="<?php echo $active->alias; ?> ">



<div class="main_header">

	<div class="main_slider"><jdoc:include type="modules" name="place1" style="none" /></div>

	<div class="logo_menu navbar-fixed-top">

		<div class="container">

			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-main-collapse">

				<i class="fa fa-bars"></i>

			</button>

			<div class="logo"><jdoc:include type="modules" name="place2" style="none" /></div>

			<div class="top_menu collapse navbar-collapse navbar-main-collapse"><jdoc:include type="modules" name="place3" style="none" /></div>

		</div>

	</div>

</div>



<div class="section_one">

	<div class="container">

		<jdoc:include type="modules" name="place4" style="well" />

		<jdoc:include type="modules" name="place5" style="none" />

	</div>

</div>



<div class="section_tow">

	<div class="container">

		<jdoc:include type="component" />

	</div>

</div>



<div class="section_three">

	<div class="container">

		<jdoc:include type="modules" name="place6" style="well" />

	</div>

</div>



<div class="section_four">

	<div class="container">

		<jdoc:include type="modules" name="place7" style="well" />

	</div>

</div>



<div class="section_five">

	<div class="container">

		<jdoc:include type="modules" name="place8" style="none" />

	</div>

</div>



<div class="section_sex">

		<jdoc:include type="modules" name="place9" style="none" />

</div>



<div class="section_seven">

	<div class="container">

		<jdoc:include type="modules" name="place10" style="none" />

	</div>

</div>



</body>

</html>

